/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.client.model;

import com.google.common.primitives.Ints;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.ForgeHooksClient;
import org.cyclops.cyclopscore.helper.Helpers;

public abstract class DynamicBaseModel
implements BakedModel {
    protected static final float[][] ROTATION_UV = new float[][]{{1.0f, 0.0f}, {1.0f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}};
    protected static final int[] ROTATION_FIX = new int[]{2, 0, 2, 0, 1, 3};
    protected static final float[][] UVS = new float[][]{{0.0f, 0.0f}, {1.0f, 1.0f}};

    protected static Vec3 rotate(Vec3 vec, Direction side) {
        switch (side) {
            case DOWN: {
                return new Vec3(vec.f_82479_, -vec.f_82480_, -vec.f_82481_);
            }
            case UP: {
                return new Vec3(vec.f_82479_, vec.f_82480_, vec.f_82481_);
            }
            case NORTH: {
                return new Vec3(vec.f_82479_, vec.f_82481_, -vec.f_82480_);
            }
            case SOUTH: {
                return new Vec3(vec.f_82479_, -vec.f_82481_, vec.f_82480_);
            }
            case WEST: {
                return new Vec3(-vec.f_82480_, vec.f_82479_, vec.f_82481_);
            }
            case EAST: {
                return new Vec3(vec.f_82480_, -vec.f_82479_, vec.f_82481_);
            }
        }
        return vec;
    }

    protected static Vec3 revRotate(Vec3 vec, Direction side) {
        switch (side) {
            case DOWN: {
                return new Vec3(vec.f_82479_, -vec.f_82480_, -vec.f_82481_);
            }
            case UP: {
                return new Vec3(vec.f_82479_, vec.f_82480_, vec.f_82481_);
            }
            case NORTH: {
                return new Vec3(vec.f_82479_, -vec.f_82481_, vec.f_82480_);
            }
            case SOUTH: {
                return new Vec3(vec.f_82479_, vec.f_82481_, -vec.f_82480_);
            }
            case WEST: {
                return new Vec3(vec.f_82480_, -vec.f_82479_, vec.f_82481_);
            }
            case EAST: {
                return new Vec3(-vec.f_82480_, vec.f_82479_, vec.f_82481_);
            }
        }
        return vec;
    }

    protected static int[] vertexToInts(float x, float y, float z, int color, TextureAtlasSprite texture, float u, float v) {
        return new int[]{Float.floatToRawIntBits(x), Float.floatToRawIntBits(y), Float.floatToRawIntBits(z), color, Float.floatToRawIntBits(texture.m_118367_((double)u)), Float.floatToRawIntBits(texture.m_118393_((double)v)), 0, 0};
    }

    protected static void addBakedQuad(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, Direction side) {
        DynamicBaseModel.addBakedQuad(quads, x1, x2, z1, z2, y, texture, -1, side);
    }

    protected static void addBakedQuad(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, int shadeColor, Direction side) {
        DynamicBaseModel.addBakedQuad(quads, x1, x2, z1, z2, y, texture, shadeColor, side, false);
    }

    protected static void addColoredBakedQuad(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, Color shadeColor, Direction side) {
        int color = Helpers.RGBAToInt(shadeColor.getBlue(), shadeColor.getGreen(), shadeColor.getRed(), shadeColor.getAlpha());
        DynamicBaseModel.addColoredBakedQuad(quads, x1, x2, z1, z2, y, texture, color, side);
    }

    protected static void addColoredBakedQuad(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, int shadeColor, Direction side) {
        DynamicBaseModel.addBakedQuad(quads, x1, x2, z1, z2, y, texture, shadeColor, side, true);
    }

    private static void addBakedQuad(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, int shadeColor, Direction side, boolean isColored) {
        DynamicBaseModel.addBakedQuadRotated(quads, x1, x2, z1, z2, y, texture, side, 0, isColored, shadeColor, new float[][]{{x1, z1}, {x1, z2}, {x2, z2}, {x2, z1}});
    }

    protected static void addBakedQuadRotated(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, Direction side, int rotation) {
        DynamicBaseModel.addBakedQuadRotated(quads, x1, x2, z1, z2, y, texture, side, rotation, false, -1, ROTATION_UV);
    }

    protected static void addBakedQuadRotated(List<BakedQuad> quads, float x1, float x2, float z1, float z2, float y, TextureAtlasSprite texture, Direction side, int rotation, boolean isColored, int shadeColor, float[][] uvs) {
        Vec3 v1 = DynamicBaseModel.rotate(new Vec3((double)x1 - 0.5, (double)y - 0.5, (double)z1 - 0.5), side).m_82520_(0.5, 0.5, 0.5);
        Vec3 v2 = DynamicBaseModel.rotate(new Vec3((double)x1 - 0.5, (double)y - 0.5, (double)z2 - 0.5), side).m_82520_(0.5, 0.5, 0.5);
        Vec3 v3 = DynamicBaseModel.rotate(new Vec3((double)x2 - 0.5, (double)y - 0.5, (double)z2 - 0.5), side).m_82520_(0.5, 0.5, 0.5);
        Vec3 v4 = DynamicBaseModel.rotate(new Vec3((double)x2 - 0.5, (double)y - 0.5, (double)z1 - 0.5), side).m_82520_(0.5, 0.5, 0.5);
        int[] data = Ints.concat((int[][])new int[][]{DynamicBaseModel.vertexToInts((float)v1.f_82479_, (float)v1.f_82480_, (float)v1.f_82481_, shadeColor, texture, uvs[(0 + rotation) % 4][0] * 16.0f, uvs[(0 + rotation) % 4][1] * 16.0f), DynamicBaseModel.vertexToInts((float)v2.f_82479_, (float)v2.f_82480_, (float)v2.f_82481_, shadeColor, texture, uvs[(1 + rotation) % 4][0] * 16.0f, uvs[(1 + rotation) % 4][1] * 16.0f), DynamicBaseModel.vertexToInts((float)v3.f_82479_, (float)v3.f_82480_, (float)v3.f_82481_, shadeColor, texture, uvs[(2 + rotation) % 4][0] * 16.0f, uvs[(2 + rotation) % 4][1] * 16.0f), DynamicBaseModel.vertexToInts((float)v4.f_82479_, (float)v4.f_82480_, (float)v4.f_82481_, shadeColor, texture, uvs[(3 + rotation) % 4][0] * 16.0f, uvs[(3 + rotation) % 4][1] * 16.0f)});
        ForgeHooksClient.fillNormal((int[])data, (Direction)side);
        quads.add(new BakedQuad(data, -1, side, texture, false));
    }

    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return Collections.emptyList();
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    public ItemOverrides m_7343_() {
        return ItemOverrides.f_111734_;
    }
}

